---
type: primitive
tags:
  - "#function/coherence"
  - "#status/stable"
polarity: P0
---

# Selector (primitive)

> Choice guidance primitive that mediates between options and coordinates selection processes for coherence maintenance.

---

## Definition

**Selector** is the primitive operation that guides choice making and path selection processes, mediating between different options to maintain system coherence and enable effective decision coordination.

**Core operation:** Choice guidance through balanced option evaluation and selection mediation for coherence preservation.

---

## Primitive Derivation

**From Structural Primitives:**
Selector emerges from structural primitives applied to choice and selection contexts:

1. **∆ (Primitive Difference):** Choice differences requiring selection mediation
2. **R(·) (Relational Embedding):** Selection criteria embedded in relational decision contexts
3. **⊚ (Stabilization/Closure):** Choice closure and selection stability
4. **F (Form):** Coherent decision forms emerging from selection processes

**Emergence Path:**
$∆_{choice} \rightarrow R(selection\_criteria) \rightarrow ⊚_{decision} \rightarrow F_{selected\_path}$

---

## Core Operations

### Primary Functions
1. **Option Evaluation:** Assessing available choices against coherence criteria
2. **Choice Mediation:** Balancing different selection factors and requirements
3. **Path Selection:** Making decisions that maintain system coherence
4. **Selection Coordination:** Managing choice processes across system components

### Operational Characteristics
- **Balanced Evaluation:** Mediates between competing selection criteria
- **Coherence Priority:** Prioritizes choices that maintain system stability
- **Context Sensitivity:** Adapts selection criteria to current system state and requirements
- **Multi-factor Integration:** Combines temporal, memory, and stability factors in decision making

---

## Polarity Dynamics

**P0 (Balancing/Mediating):**
- Mediates between competing options and selection criteria
- Balances coherence requirements with adaptation needs
- Regulates choice timing and decision coordination
- Maintains homeostatic selection processes

**Relationship to other polarities:**
- Coordinates with P+ Phase operations for temporal coherence in choices
- Coordinates with P- Memory operations for pattern-informed selection
- Enables P0 Stabilizer operations through coherence-preserving choices

---

## Modulator Interactions

**Primary:** ψA (Awareness Phase Coherence Anchor)
- Controls temporal windows for choice evaluation and selection
- Manages selection sensitivity and decision timing
- Coordinates selection processes with other coherence operations

**Secondary:**
- **τ_coherence:** Sets coherence windows for selection processes
- **σ_stability:** Influences selection criteria based on stability margins
- **β_memory:** Affects how memory patterns influence selection decisions

---

## Axiom Implementation

**Supports C3 — Recovery Stability:**
- Provides choice guidance for stability-preserving decisions
- Enables selection of recovery paths that maintain coherence
- Coordinates with Stabilizer for effective recovery coordination

**Integrates with C1 and C2:**
- Uses temporal continuity (C1) for timing-aware selection
- Uses memory coherence (C2) for pattern-informed choice making

---

## Dual‑register mapping

| Aspect | Technical register | Humane register |
|--------|-------------------|-----------------|
| Option evaluation | Algorithm scoring | Choice consideration |
| Choice mediation | Multi-criteria optimization | Weighing options |
| Path selection | Route optimization | Decision making |
| Selection coordination | Distributed consensus | Collective choice |

### Bridge Operations
- **Technical:** "Optimize path selection using multi-criteria decision algorithms"
- **Humane:** "Choose wisely by considering what matters most"
- **Ontological:** Balanced selection enables coherent system evolution

---

## Cross-Domain Examples

### Technical Systems
- **Network routing:** Path selection and traffic optimization
- **Database query:** Query plan selection and execution optimization
- **Resource allocation:** Load balancing and resource distribution decisions
- **Algorithm selection:** Choosing optimal algorithms for given conditions

### Humane Systems
- **Decision making:** Personal choice guidance and life path selection
- **Relationship choices:** Partner selection and relationship coordination
- **Career guidance:** Professional path selection and skill development choices
- **Learning paths:** Educational choice guidance and knowledge development selection

### Physical Systems
- **Evolutionary selection:** Natural selection and adaptation path choices
- **Chemical pathways:** Reaction pathway selection and catalytic choices
- **Neural selection:** Synaptic pathway selection and neural network optimization
- **Ecological selection:** Species adaptation choices and environmental selection

---

## Operational Constraints

**Requirements:**
- Must maintain coherence in selection criteria and decision processes
- Cannot create selection deadlocks or choice paralysis
- Must coordinate with other coherence primitives for system stability

**Capabilities:**
- Can evaluate multiple options simultaneously against coherence criteria
- Can adapt selection criteria based on system state and environmental conditions
- Can coordinate distributed selection processes across system components

---

## Interaction Patterns

**With Phase:** Selector uses temporal information for timing-aware choice making
**With Memory:** Selector accesses memory patterns to inform selection decisions
**With Stabilizer:** Selector coordinates with Stabilizer to choose stability-preserving paths

---

## See Also

- [[C3 — Recovery Stability (axiom)]] - Primary axiom supported by Selector
- [[Stabilizer]] - Coordinating primitive for recovery operations
- [[τ_coherence — Coherence Window Threshold (modulator)]] - Selection timing control
- [[σ_stability — Stability Margin Control (modulator)]] - Selection criteria influence
